/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.pa.problem;

import com.ibm.hwmca.base.pa.problem.GetProblemData;
import com.ibm.hwmca.fw.pa.ProblemAnalysisManager;
import com.ibm.hwmca.fw.pa.fedc.FEDCJavaExecutable;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.util.NativeProcess;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import java.io.IOException;

public class RunActAPI
implements Runnable,
FEDCJavaExecutable {
    private int functionToPerform = 0;
    private PASystem cecSystem = null;
    private String cecMT = null;
    private String cecMS = null;
    private String partionID = null;
    private static final String localFN = "oseedFromEvent.dat";
    private String remoteFN = null;
    private static final String fileOwner = "hscroot";
    private static final String fileGroup = "users";
    private static final String baseCMD = "runact-api";
    private static final String TRACE_MASKT = "XRUNACTT";
    private static final String TRACE_MASKF = "XRUNACTF";
    private static final String TRACE_MASKD = "XRUNACTD";
    private static final String DEFAULT_EED_PATH = "eeddirectory";
    private String _parms = null;
    private Problem _problem;

    public RunActAPI(String parms) {
        Trace.trace(TRACE_MASKT, "--> RunActAPI.ctor (" + parms + ")");
        this._parms = parms;
    }

    public Problem getProblem() {
        Trace.trace(TRACE_MASKT, "<--> getProblem ");
        return this._problem;
    }

    public void setProblem(Problem problem) {
        Trace.trace(TRACE_MASKT, "--> setProblem ");
        this._problem = problem;
        Trace.trace(TRACE_MASKD, "the problem is " + problem.getUniqueKey());
        Trace.trace(TRACE_MASKT, "<-- setProblem ");
    }

    public void run() {
        Trace.trace(TRACE_MASKD, "running RunActAPI with parm=" + this._parms);
        if (this._problem != null) {
            Trace.trace(TRACE_MASKD, "running for problem " + this._problem.getUniqueKey());
        } else {
            Trace.trace(TRACE_MASKD, "the problem wasn't set");
        }
        if (this._problem == null) {
            return;
        }
        PIProblem myPIProblem = null;
        if (this.getProblem() instanceof PIProblem) {
            myPIProblem = (PIProblem)this.getProblem();
        }
        String parmsToInvokeWith = "-c IBM.ServiceEvent::::getFileFromPartition::CallerID::0::CecMT::\"" + myPIProblem.getFailingSystem().getMachineType() + "\"::CecMS::\"" + myPIProblem.getFailingSystem().getMachineSerial() + "\"::PartionID::\"" + myPIProblem.getPartitionID() + "\"::LocalFN::\"" + this.getLocalFN() + "\"::RemoteFN::\"" + myPIProblem.getEED() + "\"::LocalFileInfo::\"File_PERM=755;FILE_OWNER=" + RunActAPI.getFileOwner() + ";FILE_GROUP=" + RunActAPI.getFileGroup() + "\"";
        if (this._parms != null && this._parms.equals("collect")) {
            parmsToInvokeWith = "-c IBM.sfp::::updateStatus::Action::\"Closed\"::MTypeModel::\"" + myPIProblem.getFailingSystem().getMachineType() + "\"::MSerial::\"" + myPIProblem.getFailingSystem().getMachineSerial() + "\"::PartitionID::\"" + myPIProblem.getPartitionID() + "\"::ErrLogSeqNum::\"" + myPIProblem.getSequencNumber() + "\"::PlatformLogID::\"" + myPIProblem.getPlatformLogID() + "\"::ErrorLogLabel::\"" + myPIProblem.getErrorLogLabelID() + "\"";
        }
        String[] cmdArray = new String[]{baseCMD, parmsToInvokeWith};
        if (this._parms != null && this._parms.equals("collect") && (myPIProblem.getEED() == null || myPIProblem.getEED() != null && myPIProblem.getEED().equals(""))) {
            Trace.trace(TRACE_MASKD, "<-- Nothing to collect we don't need to do this return ");
            return;
        }
        Trace.trace(TRACE_MASKD, "calling NativeProcess to runact-api with parms " + parmsToInvokeWith);
        int rc = -1;
        try {
            rc = RootProcess.executeProgram(cmdArray);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        Trace.trace(TRACE_MASKD, "NativeProcess of runact-api completed with rc= " + rc);
    }

    public static void main(String[] args) {
        GetProblemData me = new GetProblemData("test");
        try {
            Trace.trace(TRACE_MASKD, "start up the problem manager");
            Thread myThread = new Thread(new ProblemAnalysisManager.Init());
            myThread.start();
            Thread.sleep(5000L);
            Trace.trace(TRACE_MASKD, "done starting the manager");
            me.run();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "got an exception");
            Trace.trace(TRACE_MASKD, e);
        }
    }

    public static String getFileGroup() {
        return fileGroup;
    }

    public static String getFileOwner() {
        return fileOwner;
    }

    public String getCecMS() {
        return this.cecMS;
    }

    public String getCecMT() {
        return this.cecMT;
    }

    public PASystem getCecSystem() {
        return this.cecSystem;
    }

    public int getFunctionToPerform() {
        return this.functionToPerform;
    }

    public String getLocalFN() {
        return localFN;
    }

    public String getPartionID() {
        return this.partionID;
    }

    public String getRemoteFN() {
        return this.remoteFN;
    }

    public void setCecMS(String string) {
        this.cecMS = string;
    }

    public void setCecMT(String string) {
        this.cecMT = string;
    }

    public void setCecSystem(PASystem system) {
        this.cecSystem = system;
        this.setCecMS(system.getMachineSerial());
        this.setCecMT(system.getMachineType());
    }

    public void setFunctionToPerform(int i) {
        this.functionToPerform = i;
    }

    public void setPartionID(String string) {
        this.partionID = string;
    }

    public void setRemoteFN(String string) {
        this.remoteFN = string;
    }

    private static int getExitStatus(NativeProcess np) {
        boolean done = false;
        int exitStatus = -1;
        while (!done) {
            try {
                exitStatus = np.waitFor();
                done = true;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        Trace.trace(TRACE_MASKF, "Exit status from root program = " + exitStatus);
        return exitStatus;
    }
}

